
#if defined NUMAYA_EXPORTS || defined _NUTOOL || defined DYNOMAYA
#define NuFileGetEndianSwapOnRead() (0)
#endif

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
template <class Type> Type* AllocateArray( int Count )
{
#if defined NUMAYA_EXPORTS || defined _NUTOOL || defined DYNOMAYA
	return new Type[Count];
#else
	return (Type *)Memory::SystemAlloc( sizeof(Type) * Count );
#endif
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
template <class Type> void FreeArray( Type* array, int Count )
{
	#if defined NUMAYA_EXPORTS || defined _NUTOOL || defined DYNOMAYA
	//DO NOT CALL DELETE AT THE MOMENT.
	//On the Maya side, this deletes data that is pointed by the ExportArray lists of PinnerDynamics.
	//This happens because the ExportArray::push_back does an assign rather than a copy of the DataType.
	//Should be a placement new that calls a copy constructor (these constructors do not exist currently).
	
	//delete [] array;
	#else
	Memory::SystemFree( array );//, sizeof(Type) * Count );
	#endif
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
template <class Type> void FreeAbstractArray( Type* array )
{
#if defined NUMAYA_EXPORTS || defined _NUTOOL || defined DYNOMAYA
	//DO NOT CALL DELETE AT THE MOMENT.
	//On the Maya side, this deletes data that is pointed by the ExportArray lists of PinnerDynamics.
	//This happens because the ExportArray::push_back does an assign rather than a copy of the DataType.
	//Should be a placement new that calls a copy constructor (these constructors do not exist currently).

	//delete [] array;
#else
	delete [] array;
#endif
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
template <class Type> Type*  ReadArray( NUFILE &fh, int Count )
{		
	//Get storage for the array.
	Type* Data = NULL;
	Data = AllocateArray<Type>( Count );

	int i; short s; char c;
	for (int j=0; j<Count; j++)
	{
		if (sizeof(Type) == 4 )			{ i = NuFileReadInt(fh);   Data[j] = *( (Type*) &i); }
		else if (sizeof(Type) == 2 )	{ s = NuFileReadShort(fh); Data[j] = *( (Type*) &s); }
		else if (sizeof(Type) == 1 )	{ c = NuFileReadChar(fh);  Data[j] = *( (Type*) &c); }	
		else							NuError("Not supported");
	}		

	return Data;
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
template <class Type> void WriteArray( NUFILE &fh, Type Data[], int Count )
{
	if (Data == NULL) return;

	for (int i=0; i<Count; i++)
	{
		if (sizeof(Type) == 4 )			NuFileWriteInt(fh, *((int*) &Data[i]) );
		else if (sizeof(Type) == 2 )	NuFileWriteShort( fh, *((short*) &Data[i]) );
		else if (sizeof(Type) == 1 )	NuFileWriteChar( fh, *((char*) &Data[i]) );	
	}
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
template <class Type> void WriteAbstractArray( NUFILE &fh, Type Data[], int Count )
{
	if (Data == NULL) return;

	for ( int i=0; i<Count; i++)
		Data[i].Write( fh );

	for ( int i=0; i<Count; i++)
		Data[i].WriteData( fh  );
}


//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
template <class Type> Type* ReadAbstractArray( NUFILE &fh, int Count, int Version )
{
	Type* Data = NULL;

	bool FastRead = true;
	if (Version < 0)
	{
		FastRead = false;
		Version = -Version;
	}

	//Get storage for the array.
	Data = new Type[Count];
			
	for (int i=0; i<Count; i++)
		Data[i].Read( fh, Version );		

	for (int i=0; i<Count; i++)
		Data[i].ReadData( fh, Version );

	return Data;

}
